//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: Zach
//
// Date: Sep 13, 2007
//---------------------

package org.cleversafe.util.httpserver;
import org.cleversafe.util.httpserver.exceptions.ServerStartFailedException;
import org.cleversafe.util.httpserver.exceptions.ServerStopFailedException;

/**
 * Simple wrapper interface for a HTTP servlet server.  
 * 
 * @author Zachary Mark
 */
public interface HttpServletServer
{
   /**
    * Start the HTTP servlet server.
    * 
    * @throws ServerStartFailedException
    */
   public void start() throws ServerStartFailedException;
   
   /**
    * Add a WAR to be served by the servlet server.
    * 
    * @param warPath The path to the WAR
    * @param webPath The web path where this is to be served (i.e. /images etc)
    */
   public void registerWar(String warPath, String webPath);
   
   /**
    * Stop the HTTP servlet server.
    * 
    * @throws ServerStopFailedException
    */
   public void stop() throws ServerStopFailedException;
}

