//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: mmotwani
//
// Date: Jun 5, 2007
//---------------------

package org.cleversafe.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.xml.XMLConstants;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;

import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/**
 * Utility to parse from an XML file or stream and return a DOM Document object. Validates against a
 * schema if one is provided.
 * 
 * @author Manish Motwani
 */
public class XMLParser
{
   private static Logger _logger = Logger.getLogger(XMLParser.class);

   public static Document parse(final String xmlFileName) throws ParserConfigurationException,
         SAXException, IOException
   {
      return parse(xmlFileName, null);
   }

   public static Document parse(final InputStream xmlStream) throws ParserConfigurationException,
         SAXException, IOException
   {
      return parse(xmlStream, null);
   }

   public static Document parse(final String xmlFileName, final String xsdFileName)
         throws ParserConfigurationException, SAXException, IOException
   {
      assert xmlFileName != null;

      InputStream xmlStream = new FileInputStream(xmlFileName);

      InputStream xsdStream = null;
      if (xsdFileName != null)
      {
         xsdStream = new FileInputStream(xsdFileName);
      }

      return parse(xmlStream, xsdStream);
   }

   public static Document parse(final InputStream xmlStream, final InputStream xsdStream)
         throws ParserConfigurationException, SAXException, IOException
   {
      assert xmlStream != null;

      Document document = null;

      XMLParser._logger.debug("Parsing XML Document.");
      final DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();

      // Parse
      document = builder.parse(xmlStream);
      XMLParser._logger.debug("Done parsing XML Document.");

      // Allow parsing XML without validating with schema
      if (xsdStream != null)
      {
         // Validation
         XMLParser._logger.debug("Validating XML Document.");
         final SchemaFactory factory =
               SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
         final Source schemaFile = new StreamSource(xsdStream);
         final Schema schema = factory.newSchema(schemaFile);
         final Validator validator = schema.newValidator();
         validator.validate(new DOMSource(document));
         XMLParser._logger.debug("Done validating XML Document.");
      }

      return document;
   }

}
