//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: Zachary Mark
//
// Date: Oct 16, 2007
//---------------------

package org.cleversafe.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

// TODO: Describe class or interface
public class WrapperScriptGenerator
{
   private static final String WRAPPER_CLASSPATH = "wrapper.java.classpath.";
   private static final String CLASSPATH_MARKER = "@CLASSPATH@";
   private static final String BASEPATH_MARKER = "@BASEPATH@";

   /**
    * @param args
    */
   public static void main(String[] args) throws FileNotFoundException, IOException
   {
      // arg 0: wrapper script template file
      // arg 1: output file name
      // arg 2: base path to replace @BASEPATH@ declarations with (usually . as it will
      //        auto-resolve absolute path names
      // arg 3-infinity: folders to iterate through

      InputStream inFile = new FileInputStream(args[0]);
      FileOutputStream outFile = new FileOutputStream(args[1]);

      File basePath = new File(args[2]);
      StringBuffer buf = new StringBuffer();

      int classNumber = 1;
      int argIndex = 2;
      while (++argIndex < args.length)
      {
         File classPath = new File(args[argIndex]);
         File[] fileList = classPath.listFiles();

         // This can happen if classPath refers to a file and not a path.
         if (fileList != null)
         {
            for (int inc = 0; inc < fileList.length; inc++)
            {
               if (!fileList[inc].isDirectory())
               {
                  String str = fileList[inc].getCanonicalPath();
                  buf.append(WRAPPER_CLASSPATH + classNumber++ + "=" + str
                        + System.getProperty("line.separator"));
               }
            }
         }
      }

      String str = readStreamAsString(inFile);
      inFile.close();

      str = str.replace((CharSequence) CLASSPATH_MARKER, (CharSequence) buf.toString());
      str = str.replace((CharSequence) BASEPATH_MARKER, (CharSequence) basePath.getCanonicalPath());
      outFile.write(str.getBytes());
      outFile.close();
   }

   // This assumes that the stream has an end.
   private static String readStreamAsString(InputStream istream) throws IOException
   {
      StringBuffer fileString = new StringBuffer();
      while (istream.available() > 0)
      {
         fileString.append((char) istream.read());
      }

      return fileString.toString();
   }
}
