//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: dhendrickson
//
// Date: Aug 8, 2007
//---------------------

package org.cleversafe.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TestChecker
{
   public Map<File, Boolean> compare(String srcDir, String testDir)
   {
      List<File> srcFiles = getSourceFiles(new File(srcDir));

      Map<File, Boolean> fileMap = new TreeMap<File, Boolean>();

      for (File srcFile : srcFiles)
      {
         if (!srcFile.isDirectory())
         {
            String srcStem = getStem(srcFile, srcDir);

            File testFile =
                  new File(testDir + System.getProperty("file.separator") + srcStem + "Test.java");
            fileMap.put(srcFile, testFile.exists());
         }
      }

      return fileMap;
   }

   private List<File> getSourceFiles(File root)
   {
      List<File> result = new ArrayList<File>();

      File[] children = root.listFiles();
      List<File> filesDirs = Arrays.asList(children);
      Iterator<File> iterator = filesDirs.iterator();

      while (iterator.hasNext())
      {
         File file = iterator.next();
         if (!file.getName().equalsIgnoreCase(".svn"))
         {
            if (!file.isFile())
            {
               List<File> subList = getSourceFiles(file);
               result.addAll(subList);
            }
            else if (file.getName().contains(".java"))
            {
               result.add(file);
            }
         }
      }

      return result;
   }

   private String getStem(File file, String rootPath)
   {
      String stem = file.getPath();

      if (stem.contains(rootPath))
      {
         int idx = stem.indexOf(rootPath);
         if (idx == 0)
         {
            stem = stem.substring(rootPath.length() + 1);
         }
      }

      if (stem.contains(".java"))
      {
         int idx = stem.indexOf(".java");
         stem = stem.substring(0, idx);
      }

      return stem;
   }

   public static void main(String args[])
   {
      if (args.length != 2)
      {
         System.out.println("Usage: TestChecker <src-dir> <unit-test-dir>");
      }

      TestChecker checker = new TestChecker();
      Map<File, Boolean> files = checker.compare(args[0], args[1]);

      Set<File> set = files.keySet();
      Iterator<File> iterator = set.iterator();
      int count = 0;
      while (iterator.hasNext())
      {
         File file = iterator.next();
         if (files.get(file))
         {
            System.out.println(file.getPath());
            count++;
         }
      }
      System.out.println(count + " units tested.");
      System.out.println();

      iterator = set.iterator();
      count = 0;
      while (iterator.hasNext())
      {
         File file = iterator.next();
         if (!files.get(file))
         {
            System.out.println(file.getPath());
            count++;
         }
      }
      System.out.println(count + " units untested.");
   }
}
