//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: Zachary Mark
//
// Date: Nov 2, 2007
//---------------------

package org.cleversafe.util;

import java.io.File;
import java.io.IOException;

// Class which performs the following task:
// Scan [projectclasspath] for files.  If [aspectclass] contains the same file with the same
// folder structure, move the file from [aspectclass] to [dest] with full subdirectory structure.

// Example:

//  /src/test/file1.txt
//  /src/test/file2.txt
//  /asp/test/file1.txt
// ProjectClassUnweaver src asp dest yields:
//  /src/test/file1.txt
//  /src/test/file2.txt
//  /dest/test/file1.txt
public class ProjectClassUnweaver
{
   public static void main(String[] args) throws IOException
   {
      // arg 0: "unaspected" path
      // arg 1: "aspected" path
      // arg 2: destination path

      if (args.length != 3)
      {
         System.out.println("Usage:  ProjectClassUnweaver [projectclass] [aspectclass] [dest]");
      }
      File unaspectedPath = new File(args[0]);
      File aspectedPath = new File(args[1]);
      File destinationPath = new File(args[2]);

      if (!unaspectedPath.exists() || !aspectedPath.exists())
      {
         // throw exception
      }

      fileMoveRec(unaspectedPath.listFiles(), unaspectedPath, aspectedPath, destinationPath);
   }

   private static void fileMoveRec(File[] fileList, File srcPath, File aspectPath, File destPath)
         throws IOException
   {
      // Is it possible to have a non-null, zero-length array?
      if (fileList == null || (fileList.length == 0))
      {
         return;
      }
      for (int inc = 0; inc < fileList.length; inc++)
      {
         if (fileList[inc].isDirectory())
         {
            fileMoveRec(fileList[inc].listFiles(), srcPath, aspectPath, destPath);
         }
         else
         {
            // Take full canonical path name, regex remove unaspectedpath
            String srcFile = fileList[inc].getCanonicalPath();

            // Prepend full canonical aspectedpath
            srcFile = srcFile.replace(srcPath.getCanonicalPath(), aspectPath.getCanonicalPath());

            // If new path exists, move the aspected item
            // to the respective location in the destination.
            File aspectedFile = new File(srcFile);
            if (aspectedFile.exists())
            {
               // System.out.println(aspectedFile.getPath());
               File targetFile =
                     new File(fileList[inc].getCanonicalPath().replace(srcPath.getCanonicalPath(),
                           destPath.getCanonicalPath()));
               FileSystemUtils.fileMove(aspectedFile, new File(targetFile.getParent()));
            }
         }
      }
   }
}
