//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: ivolvovski
//
// Date: May 25, 2007
//---------------------

package org.cleversafe.util;

/**
 * Static helper methods used to convert configuration anmes into java names
 */
public class NamingHelper
{

   public static Package getPackageFromPackageName(String name)
   {
      return Package.getPackage(name);
   }

   public static String getPackagePathFromPackage(Package pkg)
   {
      return pkg.getName().replace('.', '/');
   }

   public static String getPackagePathFromClass(Class<?> clazz)
   {
      return getPackagePathFromPackage(clazz.getPackage());
   }
   
   /**
    * 1. Prepends set, 2. capitilizes first character 3. Replaces each -x --> X
    * block-size --> setBlockSize
    * 
    * @param name
    * @return
    */
   public static String convertNameIntoJavaSetter(final String name)
   {
      return convertNameIntoJavaMethod(name, "set", "");
   }

   public static String convertNameIntoJavaGetter(final String name)
   {
      return convertNameIntoJavaMethod(name, "get", "");

   }

   public static String convertNameIntoJavaMethod(
         final String name,
         final String prefix,
         final String suffix)
   {
      assert name != null && name.length() > 0 : "Name should have at least one character";

      final String[] parts = name.split("-");
      final StringBuffer methodName = new StringBuffer();

      assert (parts.length > 0);

      if (prefix != null)
      {
         methodName.append(prefix);
      }
      methodName.append(parts[0].substring(0, 1).toUpperCase()).append(parts[0].substring(1));
      for (int i = 1; i < parts.length; i++)
      {
         methodName.append(parts[i].substring(0, 1).toUpperCase()).append(parts[i].substring(1));
      }

      if (suffix != null)
      {
         methodName.append(suffix);
      }
      return methodName.toString();
   }
}
