//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: bcilfone
//
// Date: Mar 12, 2008
//---------------------

package org.cleversafe.test.grid;

import java.util.List;

import org.cleversafe.layer.grid.CorruptedSliceObserver;
import org.cleversafe.layer.grid.DataSource;
import org.cleversafe.layer.grid.WriteController;
import org.cleversafe.layer.grid.WriteControllerFactory;
import org.cleversafe.layer.grid.exceptions.ControllerDataTransformationException;
import org.cleversafe.layer.grid.exceptions.ControllerException;
import org.cleversafe.layer.grid.exceptions.ControllerGridStateUnknownException;
import org.cleversafe.layer.grid.exceptions.ControllerIOException;
import org.cleversafe.layer.grid.exceptions.ControllerIllegalSourceNameException;
import org.cleversafe.layer.grid.exceptions.ControllerInformationDispersalException;
import org.cleversafe.layer.grid.exceptions.ControllerStoresNotFoundException;
import org.cleversafe.layer.grid.exceptions.ControllerTransactionException;
import org.cleversafe.vault.Vault;

public class NullWriteControllerFactory implements WriteControllerFactory
{
   public WriteController getInstance(Vault vault) throws ControllerException
   {
      return new WriteController()
      {
         public void commit() throws ControllerTransactionException, ControllerIOException, ControllerStoresNotFoundException
         {
         }

         public long getTransactionId()
         {
            return 0;
         }

         public void rollback() throws ControllerTransactionException, ControllerIOException, ControllerStoresNotFoundException
         {
         }

         public void write(DataSource data) throws ControllerDataTransformationException, ControllerInformationDispersalException, ControllerIOException, ControllerIllegalSourceNameException, ControllerTransactionException, ControllerGridStateUnknownException, ControllerStoresNotFoundException
         {
         }

         public void write(List<DataSource> sources) throws ControllerDataTransformationException, ControllerInformationDispersalException, ControllerIOException, ControllerIllegalSourceNameException, ControllerTransactionException, ControllerGridStateUnknownException, ControllerStoresNotFoundException
         {
         }

         public void addCorruptedSliceObserver(CorruptedSliceObserver corruptedSliceObserver)
         {
         }

         public Vault getVault()
         {
            return null;
         }

         public boolean isOperational()
         {
            return false;
         }

         public void setVault(Vault vault)
         {
         }

         public void shutdown() throws ControllerException
         {
         }
      };
   }

   public void release(WriteController wc)
   {
   }
}
