//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: dhendrickson
//
// Date: Oct 30, 2007
//---------------------

package org.cleversafe.test;

import java.io.File;

import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.xml.DOMConfigurator;

public class BaseTest
{
   public static final String TEST_INPUT_PROPERTY = "org.cleversafe.test-input";
   public static final String TEST_OUTPUT_PROPERTY = "org.cleversafe.test-output";

   private String classPath;

   public BaseTest()
   {
      this.classPath = this.getClass().getName();
      this.classPath = this.classPath.replace(".", System.getProperty("file.separator"));

      String logConfiguration = System.getProperty("log4j.configuration");
      if (logConfiguration == null)
      {
         BasicConfigurator.configure();
      }
      else
      {
         DOMConfigurator.configure(logConfiguration);
      }
   }

   public File getInputDirectory() throws TestException
   {
      String baseInputPath = System.getProperty(TEST_INPUT_PROPERTY);
      if (baseInputPath == null)
      {
         throw new TestException(
               "Base path for test input not specified, please set system property "
                     + TEST_INPUT_PROPERTY);
      }

      String fullPath = baseInputPath + System.getProperty("file.separator") + this.classPath;

      File testInputDir = new File(fullPath);

      if (!testInputDir.exists())
      {
         throw new TestException("Test input path does not exist: "
               + testInputDir.getAbsolutePath());
      }

      if (!testInputDir.canRead())
      {
         throw new TestException("Cannot read test input path: " + testInputDir.getAbsolutePath());
      }

      return testInputDir;
   }

   public File getOutputDirectory() throws TestException
   {
      String baseOutputPath = System.getProperty(TEST_OUTPUT_PROPERTY);
      if (baseOutputPath == null)
      {
         throw new TestException(
               "Base path for test output not specified, please set system property "
                     + TEST_OUTPUT_PROPERTY);
      }

      String fullPath = baseOutputPath + System.getProperty("file.separator") + this.classPath;

      File testOutputDir = new File(fullPath);
      if (testOutputDir == null || !testOutputDir.exists())
      {
         if (!testOutputDir.mkdirs())
         {
            throw new TestException("Unable to create test output directory: "
                  + testOutputDir.getAbsolutePath());
         }
      }

      if (!testOutputDir.canRead())
      {
         throw new TestException("Cannot read from test output path: "
               + testOutputDir.getAbsolutePath());
      }

      if (!testOutputDir.canWrite())
      {
         throw new TestException("Cannot write to test output path: "
               + testOutputDir.getAbsolutePath());
      }

      return testOutputDir;
   }

   public void clean() throws TestException
   {
      File testOutputDir = getOutputDirectory();

      deleteDirectory(testOutputDir);
   }

   private void deleteDirectory(File dir)
   {
      if (dir.exists())
      {
         File[] children = dir.listFiles();
         for (int i = 0; i < children.length; i++)
         {
            if (children[i].isDirectory())
            {
               deleteDirectory(children[i]);
            }
            else
            {
               children[i].delete();
            }
         }
      }

      dir.delete();
   }
}
