//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: jquigley
//
// Date: Aug 20, 2007
//---------------------

package org.cleversafe.server.exceptions;

import org.cleversafe.exceptions.BaseException;

/**
 * This exception is thrown when Servers experience IO errors
 * 
 * @see BaseException
 */
public class ServerIOException extends BaseException
{
   private static final long serialVersionUID = 7799064703934633705L;

   /**
    * Default Constructor
    */
   public ServerIOException()
   {
   }

   /**
    * Constructs object taking a reason and cause
    * 
    * @param reason
    * @param cause
    * @see BaseException
    */
   public ServerIOException(String reason, Throwable cause)
   {
      super(reason, cause);
   }

   /**
    * Constructs object taking only a reason
    * 
    * @param reason
    * @see BaseException
    */
   public ServerIOException(String reason)
   {
      super(reason);
   }

   /**
    * Constructs object taking only a cause
    * 
    * @param cause
    * @see BaseException
    */
   public ServerIOException(Throwable cause)
   {
      super(cause);
   }
}
