//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: mmotwani
//
// Date: Aug 2, 2007
//---------------------

package org.cleversafe.server.exceptions;

/**
 * This exception is thrown when the a Server's configuration file contains invalid content
 * 
 * @see ServerException
 */
public class IllegalServerConfigurationContentException extends ServerException
{
   private static final long serialVersionUID = 6999803526436638942L;

   /**
    * Default Constructor
    */
   public IllegalServerConfigurationContentException()
   {
   }

   /**
    * Constructs object taking a reason and cause
    * 
    * @param reason
    * @param cause
    * @see ServerException
    */
   public IllegalServerConfigurationContentException(String reason, Throwable cause)
   {
      super(reason, cause);
   }

   /**
    * Constructs object taking only a reason
    * 
    * @param reason
    * @see ServerException
    */
   public IllegalServerConfigurationContentException(String reason)
   {
      super(reason);
   }

   /**
    * Constructs object taking only a cause
    * 
    * @param cause
    * @see ServerException
    */
   public IllegalServerConfigurationContentException(Throwable cause)
   {
      super(cause);
   }

}


