//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: jquigley
//
// Date: Aug 9, 2007
//---------------------

package org.cleversafe.server;

import java.util.concurrent.atomic.AtomicInteger;

import org.cleversafe.exceptions.NotImplementedException;
import org.cleversafe.layer.communication.exceptions.CommunicationIOException;
import org.cleversafe.layer.communication.exceptions.CommunicationInterruptedException;
import org.cleversafe.layer.communication.exceptions.CommunicationResponseException;
import org.cleversafe.layer.communication.exceptions.CommunicationTransmissionException;
import org.cleversafe.layer.communication.exceptions.NotConnectedException;
import org.cleversafe.layer.communication.network.IPNetworkConnector;
import org.cleversafe.layer.protocol.ProtocolMessage;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.cleversafe.serialization.ProtocolMessageFactory;

/**
 * This class wraps a ServerApplication object for interacting with a server as if it were a
 * Connector.
 * 
 * @see IPNetworkConnector
 * 
 * @author John Quigley
 */
public class ServerApplicationConnection extends IPNetworkConnector
{
   private ClientSession session;
   private ServerApplication serverApp;

   /**
    * Constructs a new instance of this class.
    * 
    * @param serverApp
    *           The ServerApplication implementation to be wrapped.
    */
   public ServerApplicationConnection(ServerApplication serverApp)
   {
      this.serverApp = serverApp;
   }

   /**
    * Performs a blocking communication, wherein a request is serviced and a response is returned.
    * 
    * @param request
    *           The request to be serviced.
    * @return The Response that is generated from servicing the request.
    * @see Request
    * @see Response
    */
   public Response exchange(Request request) throws CommunicationIOException, NotConnectedException
   {
      return serverApp.service(request, session);
   }

   /**
    * Performs a real-time communication, wherein a request is serviced within some time limit.
    * 
    * @param request
    *           The request to be serviced.
    * @param timeout
    *           The time limit during which the request must be serviced.
    * @return The Response that is generated from servicing the request.
    * @see Request
    * @see Response
    */
   public Response exchange(Request request, int timeout) throws CommunicationIOException,
         NotConnectedException, CommunicationInterruptedException, CommunicationResponseException,
         CommunicationTransmissionException
   {
      throw new NotImplementedException("not yet implemented");
   }

   /**
    * Tests whether the ServerApplication is operational.
    * 
    * @return A boolean indicating the operational state of the ServerApplication.
    */
   public boolean isConnected()
   {
      return serverApp != null;
   }

   /**
    * Creates a new ClientSession object, emulating a new client connection.
    * 
    * @see ClientSession
    */
   public void connect() throws CommunicationIOException
   {
      this.session = new ClientSession();
   }

   /**
    * Emulates a full client disconnect, closing session state.
    */
   public void disconnect() throws CommunicationIOException
   {
      serverApp = null;
   }

   /**
    * Unimplemented method that will throw a NotImplementedException at this time.
    * 
    * @return The string representation or the emulated local end-point.
    */
   public String getLocalAddress()
   {
      // TODO Auto-generated method stub
      throw new NotImplementedException("initialize");
   }

   /**
    * Blocking method that pops the notification stack when messages are queued.
    * 
    * @return The ProtocolMessage representing the earliest arrived notification message.
    * @throws CommunicationInterruptedException
    * @see ProtocolMessage
    */
   @Override
   public ProtocolMessage getNotification() throws CommunicationInterruptedException
   {
      // TODO Auto-generated method stub
      throw new NotImplementedException("not implemented");
   }

   /**
    * Blocking method that pops the notification stack when messages are queued within some time
    * limit.
    * 
    * @param timeout
    *           Specifies the
    * @return The ProtocolMessage representing the earliest arrived notification message.
    * @throws CommunicationInterruptedException
    * @see ProtocolMessage
    */
   @Override
   public ProtocolMessage getNotification(int timeout) throws CommunicationInterruptedException
   {
      // TODO Auto-generated method stub
      return null;
   }

   @Override
   public void sendPing()
   {
      // nothing to do
   }

   public ProtocolMessageFactory getProtocolMessageFactory()
   {
      throw new NotImplementedException("not implemented");
   }

   public int getNumOutstandingExchanges()
   {
      throw new NotImplementedException("not implemented");
   }
}
