//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: mmotwani
//
// Date: Oct 5, 2007
//---------------------

package org.cleversafe.serialization.raw.custom;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

import org.cleversafe.layer.grid.DataSlice;
import org.cleversafe.layer.protocol.MultipleWriteRequest;
import org.cleversafe.serialization.GridSerializable;
import org.cleversafe.serialization.exceptions.EncodeDecodeException;

public class MultipleWriteRequestSerialization extends BaseRequestSerialization
{
   public MultipleWriteRequestSerialization()
   {
      super(MultipleWriteRequest.class);
   }

   @Override
   public GridSerializable read(DataInput in) throws EncodeDecodeException, IOException
   {
      MultipleWriteRequest request = new MultipleWriteRequest();

      // Read DataSlice list
      request.setDataSlices(readObjectList(DataSlice.class, in));

      // Read allowOverwriteNewer boolean
      request.setAllowOverwriteNewer(in.readBoolean());

      return request;
   }

   @Override
   public void write(DataOutput out, GridSerializable serializable) throws EncodeDecodeException,
         IOException
   {
      assert serializable instanceof MultipleWriteRequest;
      MultipleWriteRequest request = (MultipleWriteRequest) serializable;

      // Write DataSlice list
      writeObjectList(out, request.getDataSlices() == null
            ? null
            : Arrays.asList(request.getDataSlices()));

      // Write allowOverwriteNewer boolean
      out.writeBoolean(request.getAllowOverwriteNewer());
   }

   @Override
   public int getMaxSerializedSize(GridSerializable serializable)
   {
      assert serializable instanceof MultipleWriteRequest;
      MultipleWriteRequest request = (MultipleWriteRequest) serializable;

      int size = super.getMaxSerializedSize(serializable);
      if (request.getDataSlices() != null)
      {
         size += calculateMaxSerializedSize(Arrays.asList(request.getDataSlices()));
      }
      size += 1; // overwrite newer

      return size;
   }
}
