//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: mmotwani
//
// Date: Oct 7, 2007
//---------------------

package org.cleversafe.serialization.raw.custom;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.UUID;

import org.cleversafe.layer.protocol.CreateStoreRequest;
import org.cleversafe.serialization.GridSerializable;
import org.cleversafe.serialization.exceptions.EncodeDecodeException;

public class CreateStoreRequestSerialization extends BaseRequestSerialization
{
   public CreateStoreRequestSerialization()
   {
      super(CreateStoreRequest.class);
   }

   @Override
   public void write(DataOutput out, GridSerializable serializable) throws EncodeDecodeException,
         IOException
   {
      assert serializable instanceof CreateStoreRequest;
      CreateStoreRequest request = (CreateStoreRequest) serializable;

      if (request.getVaultType() == null || request.getSliceStoreType() == null
            || request.getVaultACLBytes() == null || request.getVaultDescriptorBytes() == null
            || request.getOptions() == null)
      {
         throw new EncodeDecodeException(
               "One ore more parameters in CreateStoreRequest is/are null");
      }

      writeString(out, request.getVaultType());
      out.writeLong(request.getMaxSliceSize());
      out.writeLong(request.getSliceStoreSize());
      writeString(out, request.getSliceStoreType());
      writeString(out, request.getVaultID().toString());
      writeByteArray(out, request.getVaultACLBytes());
      writeByteArray(out, request.getVaultDescriptorBytes());
      writeStringMap(out, request.getOptions());
   }

   @Override
   public GridSerializable read(DataInput in) throws EncodeDecodeException, IOException
   {
      CreateStoreRequest request = new CreateStoreRequest();
      request.setVaultType(readString(in));
      request.setMaxSliceSize(in.readLong());
      request.setSliceStoreSize(in.readLong());
      request.setSliceStoreType(readString(in));
      request.setVaultID(UUID.fromString(readString(in)));
      request.setVaultACLBytes(readByteArray(in));
      request.setVaultDescriptorBytes(readByteArray(in));
      request.setOptions(readStringMap(in));
      return request;
   }

   @Override
   public int getMaxSerializedSize(GridSerializable serializable)
   {
      assert serializable instanceof CreateStoreRequest;
      CreateStoreRequest request = (CreateStoreRequest) serializable;

      int size = super.getMaxSerializedSize(serializable);
      size += calculateMaxSerializedSize(request.getVaultType());
      size += 16; // 2 long integers
      size += calculateMaxSerializedSize(request.getSliceStoreType());
      size += calculateMaxSerializedSize(request.getVaultID().toString());
      size += calculateMaxSerializedSize(request.getVaultACLBytes());
      size += calculateMaxSerializedSize(request.getVaultDescriptorBytes());
      size += calculateMaxSerializedSize(request.getOptions());

      return size;
   }
}
