//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: mmotwani
//
// Date: Aug 16, 2007
//---------------------

package org.cleversafe.serialization.asn1.custom;

import java.lang.reflect.Method;

import org.bouncycastle.asn1.ASN1Object;
import org.cleversafe.layer.protocol.CommitTransactionResponse;

/**
 * Implements custom ASN.1 <code>encode</code> and <code>decode</code> methods for
 * {@link CommitTransactionResponse}.
 * 
 * @see CommitTransactionResponse
 * @author Manish Motwani
 */
public class CommitTransactionResponseSerialization implements CustomSerialization
{
   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.serialization.asn1.custom.CustomSerialization#getSerializableClass()
    */
   public Class<CommitTransactionResponse> getSerializableClass()
   {
      return CommitTransactionResponse.class;
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.serialization.asn1.custom.CustomSerialization#getEncodeMethod()
    */
   public Method getEncodeMethod()
   {
      try
      {
         return CommitTransactionResponseSerialization.class.getMethod(
               "encodeCommitTransactionResponse", new Class[]{
                  getSerializableClass()
               });
      }
      catch (NoSuchMethodException nsme)
      {
         throw new RuntimeException("Error in code above.", nsme);
      }
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.serialization.asn1.custom.CustomSerialization#getDecodeMethod()
    */
   public Method getDecodeMethod()
   {
      try
      {
         return CommitTransactionResponseSerialization.class.getMethod(
               "decodeCommitTransactionResponse", new Class[]{
                     getSerializableClass(), ASN1Object.class
               });
      }
      catch (NoSuchMethodException nsme)
      {
         throw new RuntimeException("Error in code above.", nsme);
      }
   }

   /**
    * Encode method for {@link CommitTransactionResponse}.
    * 
    * @param commitTransactionResponse
    * @return
    */
   public static ASN1Object encodeCommitTransactionResponse(
         CommitTransactionResponse commitTransactionResponse)
   {
      return ResponseExceptionSerializationUtil.encodeResponseException(commitTransactionResponse);
   }

   /**
    * Decode method for {@link CommitTransactionResponse}.
    * 
    * @param commitTransactionResponse
    * @param asnObj
    */
   public static void decodeCommitTransactionResponse(
         CommitTransactionResponse commitTransactionResponse,
         ASN1Object asnObj)
   {
      ResponseExceptionSerializationUtil.decodeResponseException(commitTransactionResponse, asnObj);
   }
}
