//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: mmotwani
//
// Date: Jul 31, 2007
//---------------------

package org.cleversafe.layer.slicestore.exceptions;

/**
 * This exception is thrown by the server when a CreateStoreRequest attempts to create
 * a vault type which is unsupported by the server
 * 
 * @see SliceStoreLayerException
 */
public class UnsupportedVaultTypeException extends SliceStoreLayerException
{
   private static final long serialVersionUID = -3992994390933093003L;

   private String vaultType;

   // Used for ASN.1 decoding purposes.
   public UnsupportedVaultTypeException(String reason)
   {
      super(reason);
   }

   public UnsupportedVaultTypeException(String reason, String vaultType)
   {
      super(reason);
      this.vaultType = vaultType;
   }

   public UnsupportedVaultTypeException(String reason, String vaultType, Throwable cause)
   {
      super(reason, cause);
      this.vaultType = vaultType;
   }

   public UnsupportedVaultTypeException(String vaultType, Throwable cause)
   {
      super(cause);
      this.vaultType = vaultType;
   }

   public void setVaultType(String vaultType)
   {
      this.vaultType = vaultType;
   }

   public String getVaultType()
   {
      return this.vaultType;
   }

   @Override
   public String toString()
   {
      return super.toString() + ", Vault Type: " + this.vaultType;
   }
}
