//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: ivolvovski
//
// Date: Jan 22, 2008
//---------------------

package org.cleversafe.layer.slicestore.exceptions;
import java.util.LinkedList;
import java.util.List;

public class RepairException extends Exception
{
   private static final long serialVersionUID = -1636391258409053760L;

   List<String> reasons;
   public RepairException()
   {
      super();
      this.reasons.add("No reasons");
   }

   public RepairException(String reason, Throwable cause)
   {
      super("", cause);
      this.reasons = new LinkedList<String>();
      this.reasons.add(reason);
   }

   public RepairException(List<String> reasons, Throwable cause)
   {
      super("", cause);
      this.reasons = reasons;
   }
   
   public RepairException(List<String> reasons)
   {
      this(reasons, null);
   }
   public RepairException(Throwable cause)
   {
      super(cause);
      this.reasons = new LinkedList<String>();
      if (cause != null)
      {
         this.reasons.add(cause.getMessage());
      }
      else
      {
         this.reasons.add("Unknown");
      }
   }

   public List<String> getReasons()
   {
      return this.reasons;
   }

   public void setReasons(List<String> reasons)
   {
      this.reasons = reasons;
   }
}


