//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: ivolvovski
//
// Date: Jan 24, 2008
//---------------------

package org.cleversafe.layer.slicestore.block;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.cleversafe.layer.slicestore.GenericRepairAdvice;

public class BlockMultiFileRepairAdvice extends GenericRepairAdvice
{

   private Map<Integer, String> missingFiles = new HashMap<Integer, String>();
   private String aclFile = null;
   private String descriptorFile = null;
   private String propertiesFileName = null;

   /**
    * 
    */
   public BlockMultiFileRepairAdvice()
   {
   }

   /**
    * Adds a missing store
    * @param ifileIndex
    * @param fileName
    */
   public void addMissingFile(int ifileIndex, String fileName)
   {
      this.missingFiles.put(ifileIndex, fileName);
   }

   /**
    * List all missing data files
    * @return
    */
   public Map<Integer, String> getMissingStores()
   {
      return Collections.unmodifiableMap(this.missingFiles);
   }

   /**
    * Sets missing ACL file
    * @return
    */
   public String getMissingAclFile()
   {
      return aclFile;
   }

   /**
    * Retrieves a missing ACL file
    * @param aclFile
    */
   public void setMissingAclFile(String aclFile)
   {
      this.aclFile = aclFile;
   }

   public String getMissingDescriptorFile()
   {
      return descriptorFile;
   }

   public void setMissingDescriptorFile(String descriptorFile)
   {
      this.descriptorFile = descriptorFile;
   }

   public String toString()
   {
      StringBuffer buf = new StringBuffer(super.toString());
      if (this.getMissingAclFile() != null)
      {
         buf.append("ACL file missing:").append(this.getMissingAclFile()).append("\n");
      }
      if (this.getMissingDescriptorFile() != null)
      {
         buf.append("Descriptor file missing:").append(this.getMissingDescriptorFile()).append("\n");
      }
      if (this.getMissingPropertiesFile() != null)
      {
         buf.append("Properties file missing:").append(this.getMissingPropertiesFile()).append("\n");
      }
      for (Map.Entry<Integer, String> entry : this.getMissingStores().entrySet())
      {
         String storeName = entry.getValue();
         buf.append("Storage file missing:").append(storeName).append("\n");
      }
      return buf.toString();
   }

   public String getMissingPropertiesFile()
   {
      return propertiesFileName;
   }

   public void setMissingPropertiesFile(String propertiesFString)
   {
      this.propertiesFileName = propertiesFString;
   }



}
