//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER


package org.cleversafe.layer.slicestore;

import org.cleversafe.layer.grid.SourceName;
import org.cleversafe.serialization.GridSerializable;

/**
 * SliceInfo objects are what get returned from SliceStore's list operation
 * 
 * @see SliceStore
 */
public class SliceInfo implements GridSerializable
{
   private SourceName sourceName;
   private long transactionId;
   
   /**
    * Default Constructor
    */
   public SliceInfo()
   {
      sourceName = new SourceName();
   }

   /**
    * Constructs a SliceStoreInfo initializing all its parameters
    * 
    * @param sourceName
    * @param transactionId
    * @param length
    */
   public SliceInfo(SourceName sourceName, long transactionId)
   {
      this.sourceName = sourceName;
      this.transactionId = transactionId;
   }

   /**
    * Getter for sourceName
    * 
    * @return sourceName member variable
    */
   public SourceName getSourceName()
   {
      return this.sourceName;
   }

   /**
    * Setter for sourceName
    * 
    * @param sourceName
    */
   public void setSourceName(SourceName sourceName)
   {
      this.sourceName = sourceName;
   }

   /**
    * Getter for transactionId
    * 
    * @return transactionId member variable
    */
   public long getTransactionId()
   {
      return this.transactionId;
   }     

   /**
    * Setter for transacgtionId
    * 
    * @param transactionId
    */
   public void setTransactionId(long transactionId)
   {
      this.transactionId = transactionId;
   }

   @Override
   public boolean equals(Object object)
   {
      if (object instanceof SliceInfo)
      {
         SliceInfo that = (SliceInfo) object;

         if ((this.sourceName == null && that.sourceName != null))
         {
            return false;
         }

         if ((this.sourceName == null || this.sourceName.equals(that.sourceName))
               && this.transactionId == that.transactionId )
         {
            return true;
         }
         else
         {
            return false;
         }
      }
      else
      {
         return false;
      }
   }
   @Override
   public String toString()
   {
      return "<" + sourceName + ":" + transactionId + ">";
   }
   
}
