//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: ivolvovski
//
// Date: Jan 24, 2008
//---------------------

package org.cleversafe.layer.slicestore;

import java.util.List;

/**
 * slice store check integrity should return an object that implements this interface
 * Each manager could extend this to provide more information for each repair() method 
 */
public interface RepairAdvice
{
   public enum StoreCondition 
   {
      GOOD(0),
      PARTIAL_REPAIR(1),
      FULL_REPAIR(2),
      CORRUPT(3);
 
      int value;
      private StoreCondition(int value)
      {
         this.value = value;
      }
      public int getValue()
      {
         return this.value;
      }
   }
   /**
    * Set slice store condition, takes into consideration previous value
    * @param condition
    */   
   public void setProbableCondition(StoreCondition condition);
   
   /**
    * Set slice store condition, overwrites the previous value
    * @param condition
    */
   public void setCondition(RepairAdvice.StoreCondition condition);

   /**
    * Store conditions, one of the enum values
    * @return
    */
   public StoreCondition getStoreCondition();
   /**
    * Set of textual advices
    * @return
    */
   public List<String> getRepairAdvices();
   /**
    * Sets missing descriptor definition 
    */
   public void setMissingDescriptorDefinition();
   
   /**
    * Clears missing descriptor definition 
    */
   public void clearMissingDescriptorDefinition();
   /**
    * Reports a missing descriptor definition 
    */
   public boolean getMissingDescriptorDefinition();
}


