//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: ivolvovski
//
// Date: Jan 24, 2008
//---------------------

package org.cleversafe.layer.slicestore;
import java.util.LinkedList;
import java.util.List;

/**
 * This class implements a very basic advice
 */
public class GenericRepairAdvice implements RepairAdvice
{

   private RepairAdvice.StoreCondition condition;
   List<String> advices = new LinkedList<String>();
   boolean missingDescriptorDefinition;

   public GenericRepairAdvice()
   {
      this.condition = RepairAdvice.StoreCondition.GOOD;
      this.missingDescriptorDefinition = false;
   }
   
   /**
    * Slice Store condition
    * @return
    */
   public RepairAdvice.StoreCondition getCondition()
   {
      return condition;
   }

   /**
    * Set slice store condition which could only increase condition
    * @param condition
    */
   public void setProbableCondition(RepairAdvice.StoreCondition condition)
   {
      if (condition.getValue() > this.condition.getValue())
      {
         this.condition = condition;
      }
   }

   /**
    * Set slice store condition
    * @param condition
    */
   public void setCondition(RepairAdvice.StoreCondition condition)
   {
      this.condition = condition;
   }
   /**
    * Advice obtained during state evaluation
    * @return
    */
   public List<String> getAdvices()
   {
      return advices;
   }
   
   /**
    * Adding a single advice
    * @param advice
    */
   public void addAdvice(String advice)
   {
      this.advices.add(advice);
   }

   /**
    * Adding a group of advises
    * @param advices
    */
   public void addAdvices(List<String> advices)
   {
      this.advices.addAll(advices);
   }


   /**
    * Getting advises regarding slice store condition
    */
   public List<String> getRepairAdvices()
   {
      return this.advices;
   }

   public RepairAdvice.StoreCondition getStoreCondition()
   {
      return this.condition;
   }
   
   public void clearMissingDescriptorDefinition()
   {
      this.missingDescriptorDefinition = false;
   }

   public void setMissingDescriptorDefinition()
   {
      this.missingDescriptorDefinition = true;
   }

   public boolean getMissingDescriptorDefinition()
   {
      return this.missingDescriptorDefinition;
   }

   
   public String toString() 
   {
      StringBuffer buf = new StringBuffer();
      buf.append("Store condition:" + this.condition).append("\n");
      int i = 1;
      for (String advice : this.getAdvices())
      {
         buf.append(i).append(".").append(advice).append("\n");
         i++;
      }
      return buf.toString();
   }


}


