//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: mmotwani
//
// Date: May 29, 2007
//---------------------

package org.cleversafe.layer.protocol.exceptions;

import org.cleversafe.layer.protocol.ProtocolOperation;

/**
 * Base operation exception.
 * 
 * @author Manish Motwani
 */
public abstract class OperationException extends ProtocolLayerException

{
   private static final long serialVersionUID = -7722845349006830162L;

   protected ProtocolOperation operation;

   // Used for ASN.1 decoding purposes.
   public OperationException(String reason)
   {
      super(reason);
      this.operation = null;
   }

   public OperationException(String reason, ProtocolOperation operation)
   {
      super(reason);
      this.operation = operation;
   }

   public OperationException(String reason, ProtocolOperation operation, Throwable cause)
   {
      super(reason, cause);
      this.operation = operation;
   }

   public void setOperation(ProtocolOperation operation)
   {
      this.operation = operation;
   }

   public ProtocolOperation getOperation()
   {
      return this.operation;
   }

   @Override
   public String toString()
   {
      return super.toString() + ", Operation=" + this.operation.toString();
   }
}
