//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: mmotwani
//
// Date: May 8, 2007
//---------------------

package org.cleversafe.layer.protocol;

import java.util.List;

import org.cleversafe.layer.grid.SliceName;
import org.cleversafe.serialization.GridSerializable;

/**
 * Class for "write_notify" unsolicited protocol operation (sent from server to client).
 * 
 * The unsolicited message contains an array of {@link SliceName} that represent the names of the
 * slices that were written.
 * 
 * @author Manish Motwani
 */
public class WriteNotifyUnsolicited extends GridProtocolUnsolicitedMessage
{
   @GridSerializable.ElementOrder(order = 1)
   private SliceName[] sliceNames = null;

   /**
    * Default constructor.
    * 
    */
   public WriteNotifyUnsolicited()
   {
      super(GridProtocolOperation.WRITE_NOTIFY_UNSOLICITED);
   }

   /**
    * Constructor.
    * 
    * @param sliceNames
    *           The array of {@link SliceName}.
    */
   public WriteNotifyUnsolicited(SliceName[] sliceNames)
   {
      super(GridProtocolOperation.WRITE_NOTIFY_UNSOLICITED);
      this.sliceNames = sliceNames;
   }

   /**
    * Convenience constructor.
    * 
    * @param sliceNames
    *           The list of {@link SliceName}.
    */
   public WriteNotifyUnsolicited(List<SliceName> sliceNames)
   {
      super(GridProtocolOperation.WRITE_NOTIFY_UNSOLICITED);
      setSliceNames(sliceNames);
   }

   /**
    * Returns the array of {@link SliceName}.
    * 
    * @return The array of {@link SliceName}.
    */
   public SliceName[] getSliceNames()
   {
      return this.sliceNames;
   }

   /**
    * Sets the array of {@link SliceName}.
    * 
    * @param sliceIDs
    *           the array of {@link SliceName}.
    */
   public void setSliceNames(SliceName[] sliceNames)
   {
      this.sliceNames = sliceNames;
   }

   /**
    * Sets the list of {@link SliceName}.
    * 
    * @param sliceIDs
    *           the list of {@link SliceName}.
    */
   public void setSliceNames(List<SliceName> sliceNames)
   {
      this.sliceNames = sliceNames.toArray(new SliceName[sliceNames.size()]);
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.protocol.messages.UnsolicitedMessage#toString()
    */
   @Override
   public String toString()
   {
      if (this.sliceNames == null)
      {
         return super.toString() + " Null slice name array";
      }
      else
      {
         StringBuffer buffer = new StringBuffer();

         buffer.append(super.toString());
         buffer.append(" SliceNames: ");

         for (int i = 0; i < this.sliceNames.length; ++i)
         {
            buffer.append(this.sliceNames[i].toString());
            if (i < this.sliceNames.length - 1)
               buffer.append(", ");
         }
         buffer.append(".");

         return buffer.toString();
      }
   }
}
