//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: Jun 12, 2007
//---------------------

package org.cleversafe.layer.protocol;

import java.util.UUID;

import org.cleversafe.serialization.GridSerializable;

/**
 * Class for "vault_bind" request protocol operation (sent from client to server).
 * 
 * Represents a request to bind an open and authenticated connection to a particular vault.
 * Connections must be authenticated before a bind request is processed. More than one vault may be
 * bound to a single connection.
 * 
 * @see VaultBindResponse
 * @author Wesley Leggette
 */
public class VaultBindRequest extends GridProtocolRequest
{
   @GridSerializable.ElementOrder(order = 1)
   private String vaultIdentifier = null;

   /**
    * Constructs a request. The vault identifier is set to null.
    * 
    */
   public VaultBindRequest()
   {
      super(GridProtocolOperation.VAULT_BIND_REQUEST);
   }

   /**
    * 
    * @param vaultIdentifier
    */
   public VaultBindRequest(UUID vaultIdentifier)
   {
      super(GridProtocolOperation.VAULT_BIND_REQUEST);
      setVaultIdentifier(vaultIdentifier);
   }

   /**
    * Sets the vault identifier.
    * 
    * @param vaultIdentifier
    */
   public void setVaultIdentifier(UUID vaultIdentifier)
   {
      this.vaultIdentifier = vaultIdentifier.toString();
   }

   /**
    * Returns the vault identifier;
    * 
    * @return The vault identifier;
    */
   public UUID getVaultIdentifier()
   {
      return UUID.fromString(this.vaultIdentifier);
   }
}
