//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: Jason Resch
//
// Date: June 18, 2007
//---------------------

package org.cleversafe.layer.protocol;

import java.util.UUID;

import org.cleversafe.serialization.GridSerializable;

/**
 * Class for "remove_store" request protocol operation (sent from client to server).
 * 
 * The request contains the vault ID of the slice store being requested for termination.
 * 
 * @see RemoveStoreResponse
 * @author Jason Resch
 */
public class RemoveStoreRequest extends GridProtocolRequest
{
   @GridSerializable.ElementOrder(order = 1)
   private String vaultIdentifier = null;

   /**
    * Default constructor.
    * 
    */
   public RemoveStoreRequest()
   {
      super(GridProtocolOperation.REMOVE_STORE_REQUEST);
   }

   /**
    * Construct a CreateStoreRequest using supplied UUID and Vault ACL
    * 
    */
   public RemoveStoreRequest(UUID vaultIdentifier)
   {
      super(GridProtocolOperation.REMOVE_STORE_REQUEST);
      this.vaultIdentifier = vaultIdentifier.toString();
   }

   /**
    * Returns the Vault ID of the slice store to be removed.
    * 
    * @return The Vault ID of the slice store to be removed.
    */
   public UUID getVaultIdentifier()
   {
      return UUID.fromString(this.vaultIdentifier);
   }

   /**
    * Sets the Vault ID of the slice store to be removed.
    * 
    * @param VaultIdentifier
    *           the vault ID of the store to be removed.
    */
   public void setVaultIdentifier(UUID vaultIdentifier)
   {
      this.vaultIdentifier = vaultIdentifier.toString();
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.protocol.messages.Request#toString()
    */
   @Override
   public String toString()
   {
      if (this.vaultIdentifier == null)
      {
         return super.toString() + " Null Vault ID";
      }

      return super.toString() + " Vault ID: " + this.vaultIdentifier;
   }
}
