//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: Dusty Hendrickson
//
// Date: May 29, 2007
//---------------------

package org.cleversafe.layer.protocol;

import org.cleversafe.serialization.GridSerializable;

/**
 * Represents a response for a given KerberosPasswordRequest. It contains the authentication status
 * of the originating request and the grid account ID for the given username and password.
 * 
 * @see PasswordAuthenticationRequest
 * @author Dusty Hendrickson
 */
public class PasswordAuthenticationResponse extends GridProtocolResponse
{
   @GridSerializable.ElementOrder(order = 1)
   private boolean isAuthenticated;

   /**
    * Constructs a response. Authenticated is set to false and grid account ID is set to an empty
    * string.
    * 
    */
   public PasswordAuthenticationResponse()
   {
      super(GridProtocolOperation.PASSWORD_AUTHENTICATION_RESPONSE);

      this.isAuthenticated = false;
   }

   /**
    * Sets the authentication status of the response to true/false.
    * 
    * @param isAuthenticated
    *           The authentication status.
    */
   public void setAuthenticated(boolean isAuthenticated)
   {
      this.isAuthenticated = isAuthenticated;
   }

   /**
    * Returns the authentication status of the response.
    * 
    * @return The authentication status.
    */
   public boolean getAuthenticated()
   {
      return this.isAuthenticated;
   }
}
