//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: mmotwani
//
// Date: Aug 9, 2007
//---------------------

package org.cleversafe.layer.protocol;

import java.util.List;

import org.cleversafe.layer.grid.DataSlice;
import org.cleversafe.serialization.GridSerializable;

/**
 * Class for "multiple_read" response protocol operation (sent from server to client).
 * 
 * The response contains an array of {@link DataSlice} objects that represent the read data.
 * 
 * @see MultipleReadRequest
 * @author Manish Motwani
 */
public class MultipleReadResponse extends GridProtocolResponse
{
   @GridSerializable.ElementOrder(order = 1)
   private DataSlice[] dataSlices = null;

   /**
    * Default constructor.
    * 
    */
   public MultipleReadResponse()
   {
      super(GridProtocolOperation.MULTIPLE_READ_RESPONSE);
   }

   /**
    * Constructor.
    * 
    * @param dataSlices
    */
   public MultipleReadResponse(DataSlice[] dataSlices)
   {
      this();
      setDataSlices(dataSlices);
   }

   /**
    * Constructor.
    * 
    * @param dataSlices
    */
   public MultipleReadResponse(List<DataSlice> dataSlices)
   {
      this();
      setDataSlices(dataSlices);
   }

   /**
    * Sets the slices that were read.
    * 
    * @param dataSlices
    */
   public void setDataSlices(DataSlice[] dataSlices)
   {
      this.dataSlices = dataSlices;
   }

   /**
    * Sets the slices that were read.
    * 
    * @param dataSlices
    */
   public void setDataSlices(List<DataSlice> dataSlices)
   {
      if (dataSlices == null)
      {
         this.dataSlices = null;
      }
      else
      {
         this.dataSlices = dataSlices.toArray(new DataSlice[dataSlices.size()]);
      }
   }

   /**
    * Returns the array of slices that were read.
    * 
    * @return
    */
   public DataSlice[] getDataSlices()
   {
      return this.dataSlices;
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.layer.protocol.GridProtocolResponse#toString()
    */
   @Override
   public String toString()
   {
      StringBuffer buffer = new StringBuffer();

      buffer.append(super.toString());

      if (this.dataSlices != null)
      {
         for (int i = 0; i < this.dataSlices.length; ++i)
         {
            if (this.dataSlices[i] != null)
            {
               buffer.append(this.dataSlices[i].toString() + ";");
            }
            else
            {
               buffer.append("Null data slice");
            }
         }
      }
      else
      {
         buffer.append("Null data slice array");
      }

      return buffer.toString();
   }
}
