//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: vthornton
//
// Date: Aug 20, 2007
//---------------------

package org.cleversafe.layer.protocol;

import java.util.ArrayList;
import java.util.List;

import org.cleversafe.layer.slicestore.SliceInfo;
import org.cleversafe.serialization.GridSerializable;

/**
 * Class for "list_continue" response protocol operation (sent from server to client).
 * 
 * The response contains a <code>List</code> of {@link SliceInfo}.
 * 
 * @see ListContinueRequest
 * @author Vance Thornton
 */
public class ListContinueResponse extends GridProtocolResponse
{
   @GridSerializable.ElementOrder(order = 1)
   private List<SliceInfo> slices;

   /**
    * Default constructor.
    * 
    */
   public ListContinueResponse()
   {
      super(GridProtocolOperation.LIST_CONTINUE_RESPONSE);
      this.slices = new ArrayList<SliceInfo>();
   }

   /**
    * Constructor.
    * 
    * @param slices
    *           The list of slice IDs.
    */
   public ListContinueResponse(List<SliceInfo> slices)
   {
      super(GridProtocolOperation.LIST_CONTINUE_RESPONSE);
      this.slices = slices;
   }

   /**
    * Returns the list of slices.
    * 
    * @return The list of slices.
    */
   public List<SliceInfo> getSlices()
   {
      return this.slices;
   }

   /**
    * Sets the list of slices.
    * 
    * @param slices
    *           the list of slices.
    */
   public void setSlices(List<SliceInfo> slices)
   {
      this.slices = slices;
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.protocol.messages.Response#toString()
    */
   @Override
   public String toString()
   {
      StringBuffer buffer = new StringBuffer();

      buffer.append(super.toString());
      buffer.append(" Size=").append(this.slices.size()).append("[");
      
      // A list may be too long - print only a few
      final int COUNT_TO_PRINT = 2;
      int counter = COUNT_TO_PRINT;
      boolean first = true;
      for (SliceInfo s : slices)
      {
         if (first)
         {
            first = false;
         }
         else {
            buffer.append(", ");
         }
         buffer.append(s);
         if (--counter == 0)
         {
            break;
         }
      }
      if (this.slices.size() > COUNT_TO_PRINT)
      {
         // print a tail
         buffer.append("...").append(this.slices.get(this.slices.size()-1));
      }
      buffer.append("]");
      
      return buffer.toString();
   }
}
