//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: Jason Resch
//
// Date: June 14, 2007
//---------------------

package org.cleversafe.layer.protocol;

import org.cleversafe.serialization.GridSerializable;

/**
 * Represents a response for a given ExistsRequest. It contains the extant status of a given slice
 * name from the originating request.
 * 
 * @see ExistsRequest
 * @author Jason Resch
 */
public class ExistsResponse extends GridProtocolResponse
{
   @GridSerializable.ElementOrder(order = 1)
   private boolean exists;

   /**
    * Constructs a response. Exists is set to false.
    * 
    */
   public ExistsResponse()
   {
      super(GridProtocolOperation.EXISTS_RESPONSE);

      this.exists = false;
   }

   /**
    * Constructs a response setting the existance flag
    * 
    * @param exists
    */
   public ExistsResponse(boolean exists)
   {
      super(GridProtocolOperation.EXISTS_RESPONSE);

      this.exists = exists;
   }

   /**
    * Sets the extant status of the response to true/false.
    * 
    * @param exists
    *           The extant status.
    */
   public void setExists(boolean exists)
   {
      this.exists = exists;
   }

   /**
    * Returns the a boolean denoting whether or not a certain slice exists.
    * 
    * @return The extant status.
    */
   public boolean doesExist()
   {
      return this.exists;
   }
}
