//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: Jason Resch
//
// Date: June 14, 2007
//---------------------

package org.cleversafe.layer.protocol;

import org.cleversafe.layer.grid.SliceName;
import org.cleversafe.serialization.GridSerializable;

/**
 * Represents a "exists" protocol message for checking whether a given slice name exists on a
 * server.
 * 
 * The request contains the {@link SliceName} of the slice to be checked.
 * 
 * @see ExistsResponse
 * @author Jason Resch
 */
public class ExistsRequest extends GridProtocolRequest
{
   @GridSerializable.ElementOrder(order = 1)
   private SliceName sliceName = null;

   /**
    * Default constructor.
    * 
    */
   public ExistsRequest()
   {
      super(GridProtocolOperation.EXISTS_REQUEST);
   }

   /**
    * Constructor.
    * 
    * @param sliceID
    *           The slice ID of the slice to be checked for existence.
    */
   public ExistsRequest(SliceName sliceID)
   {
      super(GridProtocolOperation.EXISTS_REQUEST);
      this.sliceName = sliceID;
   }

   /**
    * Sets the ID of the slice to be check for existance
    * 
    * @param sliceName
    *           The ID of the slice to be checked.
    */
   public void setSliceName(SliceName sliceName)
   {
      this.sliceName = sliceName;
   }

   /**
    * 
    * @return The slice ID of the slice to be checked for existance.
    */
   public SliceName getSliceName()
   {
      return this.sliceName;
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.protocol.messages.Request#toString()
    */
   @Override
   public String toString()
   {
      return super.toString() + " SliceID: " + this.sliceName;
   }
}
