//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: mmotwani
//
// Date: May 8, 2007
//---------------------

package org.cleversafe.layer.protocol;

import org.cleversafe.serialization.GridSerializable;

/**
 * Class for "commit_transaction" request protocol operation (sent from client to server).
 * 
 * The request contains a <code>long</code> transaction ID of the transaction being requested to
 * commit.
 * 
 * @see CommitTransactionResponse
 * @author Manish Motwani
 */
public class CommitTransactionRequest extends GridProtocolRequest
{
   @GridSerializable.ElementOrder(order = 1)
   private long txid = -1;

   /**
    * Default constructor.
    * 
    */
   public CommitTransactionRequest()
   {
      super(GridProtocolOperation.COMMIT_TRANSACTION_REQUEST);
   }

   /**
    * Constructor.
    * 
    * @param transactionID
    *           Transaction ID.
    */
   public CommitTransactionRequest(long transactionID)
   {
      super(GridProtocolOperation.COMMIT_TRANSACTION_REQUEST);
      this.txid = transactionID;
   }

   /**
    * Returns Transaction ID.
    * 
    * @return Transaction ID.
    */
   public long getTransactionID()
   {
      return this.txid;
   }

   /**
    * Sets the transaction ID.
    * 
    * @param txid
    *           The transaction ID.
    */
   public void setTransactionID(long txid)
   {
      this.txid = txid;
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.protocol.messages.Request#toString()
    */
   @Override
   public String toString()
   {
      return super.toString() + " Transaction ID: " + this.txid;
   }
}
