//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: Srini (spalthepu@cleversafe.com)
//
// Date: Nov 29, 2007
//---------------------

package org.cleversafe.layer.grid.simplecontroller;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;

import org.apache.commons.lang.NotImplementedException;
import org.apache.log4j.Logger;
import org.cleversafe.layer.grid.CorruptedSliceObserver;
import org.cleversafe.layer.grid.DeleteController;
import org.cleversafe.layer.grid.OperationControllerBase;
import org.cleversafe.layer.grid.SliceName;
import org.cleversafe.layer.grid.SourceName;
import org.cleversafe.layer.grid.exceptions.ControllerIOException;
import org.cleversafe.layer.grid.exceptions.ControllerIllegalSourceNameException;
import org.cleversafe.layer.grid.simplecontroller.SimpleReadController.Order;
import org.cleversafe.layer.slicestore.SliceStore;
import org.cleversafe.vault.Vault;

public class SimpleDeleteController extends OperationControllerBase implements DeleteController
{
   private static Logger _logger = Logger.getLogger(SimpleDeleteController.class);

   // Member variables
   @SuppressWarnings("unused")
   private Order order;
   @SuppressWarnings("unused")
   private ExecutorService executor;
   @SuppressWarnings("unused")
   private StringBuffer cumulativeFailureReason = null;

   /**
    * By default normal order of slices which is performance optimal
    */
   public SimpleDeleteController(Vault vault, ExecutorService executor)
   {
      this(vault, Order.NORMAL, executor);
   }

   public SimpleDeleteController(Vault vault, Order order, ExecutorService executor)
   {
      super(vault);
      this.order = order;
      this.executor = executor;
   }

   public void delete(SourceName name) throws ControllerIOException,
         ControllerIllegalSourceNameException
   {
      List<SourceName> sourceNames = new ArrayList<SourceName>(1);
      sourceNames.add(name);

      this.deleteImpl(sourceNames);
   }

   public void delete(List<SourceName> sources) throws ControllerIOException,
         ControllerIllegalSourceNameException
   {
      this.deleteImpl(sources);
   }

   protected void deleteImpl(List<SourceName> sources) throws ControllerIOException,
         ControllerIllegalSourceNameException
   {
      // implement delete logic here.	   
      List<SliceStore> stores = this.getVault().getSliceStores();
      for (int i = 0; i < stores.size(); i++)
      {
         SliceStore store = stores.get(i);
         List<SliceName> slices = new ArrayList<SliceName>();

         _logger.debug("Deleting slices on store " + i);
         for (SourceName name : sources)
         {
            slices.add(new SliceName(name, i));
         }
         try
         {
            store.remove(slices);
         }
         catch (Exception ex)
         {
            ex.printStackTrace();
            _logger.debug("Error deleting slices on store" + i + ":" + ex);
         }
      }
   }

   public void addCorruptedSliceObserver(CorruptedSliceObserver corruptedSliceObserver)
   {
      // TODO: Implement this method
      throw new NotImplementedException("addCorruptedSliceObserver is not implemented");
   }
}
