//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: gdhuse
//
// Date: Nov 27, 2007
//---------------------

package org.cleversafe.layer.grid.ranking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.cleversafe.layer.grid.OperationScorecard;
import org.cleversafe.layer.slicestore.SliceStore;
import org.cleversafe.vault.Vault;

/**
 * Aggregates weighted rankings from multiple StoreRankings
 */
public class WeightedStoreRanking extends BaseStoreRanking
{
   // Collection of member StoreRankings and their weights in this aggregation
   private Map<StoreRanking, Float> members;

   /**
    * Facilitate construction from configuration
    */
   public WeightedStoreRanking()
   {
      this.members = new HashMap<StoreRanking, Float>();
   }

   /**
    * Construct a fully-initialized object
    * @param members
    */
   public WeightedStoreRanking(Map<StoreRanking, Float> members)
   {
      this.members = members;
   }

   /**
    * Add a member to the aggregator
    * @param member
    * @param weight
    */
   public void addMember(StoreRanking member, Float weight)
   {
      this.members.put(member, weight);
   }

   /**
    * Compute the weighted average rating for each member StoreRanking
    */
   public List<Float> rateStores(Vault vault, OperationScorecard scorecard)
   {
      List<SliceStore> stores = scorecard.getStores();
      List<Float> ratings = new ArrayList<Float>(stores.size());

      // Compute weighted sum of each member's ranking
      for (Map.Entry<StoreRanking, Float> member : this.members.entrySet())
      {
         List<Float> memberRanking = member.getKey().rateStores(vault, scorecard);
         for (int i = 0; i < ratings.size(); ++i)
         {
            Float rating = memberRanking.get(i);
            assert (rating >= 0.0) && (rating <= 1.0);

            ratings.set(i, ratings.get(i) + (member.getValue() * rating));
         }
      }

      // Average results
      for (int i = 0; i < ratings.size(); ++i)
      {
         ratings.set(i, ratings.get(i) / members.size());
      }

      this.normalize(ratings);
      return ratings;
   }
}
