//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: gdhuse
//
// Date: Nov 27, 2007
//---------------------

package org.cleversafe.layer.grid.ranking;

import java.util.List;

import org.cleversafe.layer.grid.OperationScorecard;
import org.cleversafe.layer.slicestore.SliceStore;
import org.cleversafe.vault.Vault;

/**
 * Interface for ranking SliceStores for a particular operation according to flexible criteria.
 * Controllers may use these rankings as a hint when accessing a vault.
 */
public interface StoreRanking
{
   /**
    * Compute a numeric rating normalized to the interval [0.0, 1.0] for each of the provided 
    * stores.  Controllers may, but are not required to, use this rating as a hint when accessing 
    * a vault.   
    * 
    * @param vault Vault that this operation is being performed on
    * @param scorecard Scorecard for an operation.  Ratings are returned to match the 
    *                  ordering of scorecard.getStores()
    * @return Ordered list of ratings normalized to the interval [0.0, 1.0] for each store in stores 
    */
   List<Float> rateStores(Vault vault, OperationScorecard scorecard);
   
   /**
    * Orders the stores in an operation from highest-rated to lowest-rated.  This list can be 
    * passed to OperationScorecard.setStoreOrder() if desired
    * 
    * @param vault Vault that this operation is being performed on
    * @param scorecard Scorecard for an operation.  The stores do not have to be set in any
    *                  particular order.
    * @return A list ordering stores from highest rating to lowest rating
    */
   List<SliceStore> sortStores(Vault vault, OperationScorecard scorecard);
}


