//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: gdhuse
//
// Date: Nov 27, 2007
//---------------------

package org.cleversafe.layer.grid.ranking;

import java.util.ArrayList;
import java.util.List;

import org.cleversafe.layer.grid.OperationScorecard;
import org.cleversafe.layer.grid.SourceName;
import org.cleversafe.layer.slicestore.SliceStore;
import org.cleversafe.vault.Vault;

/**
 * Rates stores based on how many slices they provide for this operation  
 */
public class MostSlicesStoreRating extends BaseStoreRanking
{
   public List<Float> rateStores(Vault vault, OperationScorecard scorecard)
   {
      List<SliceStore> stores = scorecard.getStores();
      List<SourceName> sources = scorecard.getSources();

      List<Float> ratings = new ArrayList<Float>(stores.size());

      // Determine how many slices each store provides
      for (int i = 0; i < stores.size(); ++i)
      {
         int numSlices = 0;

         for (SourceName source : sources)
         {
            OperationScorecard.Entry entry = scorecard.getEntry(source, stores.get(i));

            if (entry != null)
            {
               numSlices++;
            }
         }

         ratings.set(i, (float) numSlices);
      }

      this.normalize(ratings);
      return ratings;
   }
}
