//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: ivolvovski
//
// Date: Aug 16, 2007
//---------------------

package org.cleversafe.layer.grid;

import java.util.List;

import org.cleversafe.layer.grid.exceptions.ControllerDataTransformationException;
import org.cleversafe.layer.grid.exceptions.ControllerGridStateUnknownException;
import org.cleversafe.layer.grid.exceptions.ControllerIOException;
import org.cleversafe.layer.grid.exceptions.ControllerIllegalSourceNameException;
import org.cleversafe.layer.grid.exceptions.ControllerInformationDispersalException;
import org.cleversafe.layer.grid.exceptions.ControllerPartialWriteException;
import org.cleversafe.layer.grid.exceptions.ControllerStoresNotFoundException;
import org.cleversafe.layer.grid.exceptions.ControllerTransactionException;

/**
 * 
 * An implementation of this interface is used to write a sources to the grid. It's up to the
 * implementation to decide how many slices are required to consider success. It is tradeoff between
 * reliability and availability. However, a write controller should ensure that minimal # of slices
 * required for restoration are successfully written to the grid
 */
public interface WriteController extends OperationController
{
   /**
    * Write a single source to the grid
    * 
    * @param sourceName
    * @param data
    * @throws ControllerDataTransformationException
    * @throws ControllerInformationDispersalException
    * @throws ControllerInvalidTransactionStateException
    * @throws ControllerPartialWriteException
    * @throws ControllerWriteException
    * @throws ControllerIllegalSourceNameException
    * @throws ControllerStoresNotFoundException
    */
   public void write(DataSource data) throws ControllerDataTransformationException,
         ControllerInformationDispersalException, ControllerIOException,
         ControllerIllegalSourceNameException, ControllerTransactionException,
         ControllerGridStateUnknownException, ControllerStoresNotFoundException;

   /**
    * Write multiple sources to the grid
    * 
    * @param sources
    *           list of sources and corresponding daat to be written
    * @throws ControllerDataTransformationException
    * @throws ControllerInformationDispersalException
    * @throws ControllerInvalidTransactionStateException
    * @throws ControllerPartialWriteException
    * @throws ControllerWriteException
    * @throws ControllerIllegalSourceNameException
    * @throws ControllerStoresNotFoundException
    */
   public void write(List<DataSource> sources) throws ControllerDataTransformationException,
         ControllerInformationDispersalException, ControllerIOException,
         ControllerIllegalSourceNameException, ControllerTransactionException,
         ControllerGridStateUnknownException, ControllerStoresNotFoundException;

   /**
    * Get the ID of this grid transaction
    * 
    * @return
    */
   public long getTransactionId();

   /**
    * Force commit
    * 
    * @throws ControllerTransactionException
    * @throws ControllerIOException
    * @throws ControllerStoresNotFoundException
    */
   void commit() throws ControllerTransactionException, ControllerIOException, ControllerStoresNotFoundException;

   /**
    * Force rollback
    * 
    * @throws ControllerTransactionException
    * @throws ControllerIOException
    * @throws ControllerStoresNotFoundException
    */
   void rollback() throws ControllerTransactionException, ControllerIOException, ControllerStoresNotFoundException;
}
