//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: ivolvovski
//
// Date: Aug 30, 2007
//---------------------

package org.cleversafe.layer.grid;

import java.util.concurrent.ExecutorService;

import org.apache.log4j.Logger;
import org.cleversafe.config.ConfigurationFactory;
import org.cleversafe.config.PropertiesProvider;
import org.cleversafe.config.exceptions.ConfigurationException;
import org.cleversafe.util.BoundedThreadPoolExecutor;
import org.cleversafe.util.ThreadlessExecutor;

/**
 * Base class for multi-threaded grid controllers 
 */
public abstract class ThreadedControllerFactoryBase
{
   @SuppressWarnings("unused")
   private static Logger _logger = Logger.getLogger(ThreadedControllerFactoryBase.class);

   // Thread pool name, useful for debugging
   public static final String THREAD_POOL_NAME = "grid-controller-pool";

   // Static thread pool, initialized in static block
   private static ExecutorService executor;

   // Initialize thread pool from configuration properties
   static
   {
      try
      {
         PropertiesProvider propProvider =
               ConfigurationFactory.getPropertiesProvider(ConfigurationFactory.XML_CONFIG_TYPE);

         String[] numThreadsElement = {
               "org", "cleversafe", "layer", "grid", "controller-threads"
         };

         int numThreads = propProvider.getIntValue(numThreadsElement);
         if (numThreads == 0)
         {
            _logger.info("Initializing grid controllers: single-threaded");
            executor = new ThreadlessExecutor();
         }
         else
         {
            _logger.info("Initializing grid controllers: " + numThreads + " threads");
            executor = new BoundedThreadPoolExecutor(THREAD_POOL_NAME, numThreads);
         }
      }
      catch (ConfigurationException ex)
      {
         _logger.warn("Initializing grid controllers: No controller-threads property, defaulting to single-threaded");
         executor = new ThreadlessExecutor();
      }
   }
   
   /**
    * Get the executor allocated by this controller
    */
   protected ExecutorService getExecutor()
   {
      return executor;
   }

   /**
    * @return the poolName
    */
   public String getPoolName()
   {
      return THREAD_POOL_NAME;
   }
}
