//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: gdhuse
//
// Date: Aug 18, 2007
//---------------------

package org.cleversafe.layer.grid;

import java.util.LinkedList;
import java.util.List;

import org.cleversafe.layer.slicestore.SliceStore;

/**
 * Container for associating a SliceStore with one or more slices
 */
public class StoreSliceSet
{
   // Store that all slices in this bundle belong to
   private SliceStore store;

   // Named slices of data
   private List<DataSlice> slices;

   /**
    * Construct an empty bundle
    * 
    * @param store
    */
   public StoreSliceSet(SliceStore store)
   {
      this.store = store;
      this.slices = new LinkedList<DataSlice>();
   }

   /**
    * Construct a bundle from known data
    * 
    * @param store
    * @param slices
    */
   public StoreSliceSet(SliceStore store, List<DataSlice> slices)
   {
      this.store = store;
      this.slices = slices;
   }

   public SliceStore getSliceStore()
   {
      return this.store;
   }

   public void addSlice(DataSlice slice)
   {
      this.slices.add(slice);
   }

   public List<DataSlice> getSlices()
   {
      return this.slices;
   }
   
   public int size()
   {
      return this.slices.size();
   }
}
