//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: ivolvovski
//
// Date: Aug 16, 2007
//---------------------

package org.cleversafe.layer.grid;

import java.util.List;

import org.cleversafe.layer.grid.exceptions.ControllerDataTransformationException;
import org.cleversafe.layer.grid.exceptions.ControllerGridStateUnknownException;
import org.cleversafe.layer.grid.exceptions.ControllerIOException;
import org.cleversafe.layer.grid.exceptions.ControllerIllegalSourceNameException;
import org.cleversafe.layer.grid.exceptions.ControllerInformationDispersalException;
import org.cleversafe.layer.grid.exceptions.ControllerSliceDoesNotExistException;
import org.cleversafe.layer.grid.exceptions.ControllerStoresNotFoundException;

/**
 * 
 * An implementation of this interface is used to read a sources from the grid. It may employ
 * different strategies to decide which slices to read by minimizing: computations, load, network
 * etc A good implementation should be able to restore a source if minimally required number of how
 * many slices are required to consider success. It is tradeoff between reliability and
 * availability. However, a write controller should ensure that minimal # of slices required for
 * restoration are successfully written to the grid
 */
public interface ReadController extends OperationController
{
   /**
    * Reads a single source
    * 
    * @param name
    * @return
    * @throws ControllerDataTransformationException
    * @throws ControllerInformationDispersalException
    * @throws ControllerSliceThresholdNotAvailableException
    * @throws ControllerSliceDoesNotExistException
    * @throws ControllerGridStateUnknownException
    * @throws ControllerReadException
    * @throws ControllerIllegalSourceNameException
    * @throws ControllerStoresNotFoundException
    */
   public DataSource read(SourceName name) throws ControllerDataTransformationException,
         ControllerInformationDispersalException, ControllerIOException,
         ControllerGridStateUnknownException, ControllerIllegalSourceNameException, ControllerStoresNotFoundException;

   /**
    * Reads multiple sources
    * 
    * @param names
    * @return
    * @throws ControllerDataTransformationException
    * @throws ControllerInformationDispersalException
    * @throws ControllerSliceThresholdNotAvailableException
    * @throws ControllerSliceDoesNotExistException
    * @throws ControllerGridStateUnknownException
    * @throws ControllerReadException
    * @throws ControllerIllegalSourceNameException
    * @throws ControllerStoresNotFoundException
    */
   public List<DataSource> read(List<SourceName> names)
         throws ControllerDataTransformationException, ControllerInformationDispersalException,
         ControllerIOException, ControllerGridStateUnknownException,
         ControllerIllegalSourceNameException, ControllerStoresNotFoundException;

}
