//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: gdhuse
//
// Date: Aug 24, 2007
//---------------------

package org.cleversafe.layer.grid;

import org.cleversafe.layer.slicestore.SliceStore;

/**
 * Slice of data with a known SliceStore mapping
 */
public class PlacedDataSlice extends DataSlice
{
   /**
    * Construct a slice object that has already been mapped to a SliceStore
    * 
    * @param name
    * @param store
    * @param transactionId
    * @param data
    */
   public PlacedDataSlice(PlacedSliceName name, long transactionId, byte[] data)
   {
      super(name, transactionId, data);
   }

   /**
    * Place an existing DataSlice
    * 
    * @param slice
    * @param store
    */
   public PlacedDataSlice(DataSlice slice, SliceStore store)
   {
      this(new PlacedSliceName(slice.sliceName, store), slice.transactionId, slice.data);
   }

   @Override
   public PlacedSliceName getSliceName()
   {
      return (PlacedSliceName) this.sliceName;
   }

   public SliceStore getStore()
   {
      return this.getSliceName().getStore();
   }
}
