//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: abaptist
//
// Date: Sep 29, 2007
//---------------------

package org.cleversafe.layer.communication.policy;

/**
 * Singleton class to hold the queues for the
 * 
 * @see SmartConnectorManager. There are three queues, the idleQueue, pingQueue
 *      and errorQueue and they each run in their own thread.
 * 
 * @see TimeQueue
 * @see SmartConnectorManager
 * 
 * @author Andrew Baptist <abaptist@cleversafe.com>
 * @version $Id$
 */

public final class SmartConnectorManagerQueue
{
   // TODO: these should be read from the configuration file
   public static int IDLE_TIMEOUT = 15 * 60 * 1000; // 15 minutes
   public static int PING_TIMEOUT = 10 * 1000; // 10 seconds
   public static int ERROR_TIMEOUT = 1 * 60 * 1000; // 1 minute
   public static int SUCCESS_TIMEOUT = 5 * 1000; // 5 seconds

   // private static Logger _logger =
   // Logger.getLogger(SmartConnectorManagerQueue.class);
   public static final SmartConnectorManagerQueue instance;

   static
   {
      instance = new SmartConnectorManagerQueue();
   }

   private TimeQueue idleQueue;
   private TimeQueue pingQueue;
   private TimeQueue errorQueue;
   private TimeQueue successQueue;
   

   // initialize time queues
   private SmartConnectorManagerQueue()
   {
      this.idleQueue = new TimeQueue(IDLE_TIMEOUT, "Idle Network Queue");
      this.errorQueue = new TimeQueue(ERROR_TIMEOUT, "Error Network Queue");
      this.pingQueue = new TimeQueue(PING_TIMEOUT, "Ping Network Queue");
      this.successQueue = new TimeQueue(SUCCESS_TIMEOUT, "Success Network Queue");
   }

   /**
    * Reinitialize the queues after timeout changes have been made (used for
    * config changes)
    */
   public static void initialize()
   {
      shutdown();
      instance.idleQueue = new TimeQueue(IDLE_TIMEOUT, "Idle Network Queue");
      instance.errorQueue = new TimeQueue(ERROR_TIMEOUT, "Error Network Queue");
      instance.pingQueue = new TimeQueue(PING_TIMEOUT, "Ping Network Queue");
      instance.successQueue = new TimeQueue(SUCCESS_TIMEOUT, "Success Network Queue");
   }

   /** Return an instance to the idle queue */
   public static TimeQueue getIdleQueue()
   {
      return instance.idleQueue;
   }

   /** Return an instance to the ping queue */
   public static TimeQueue getPingQueue()
   {
      return instance.pingQueue;
   }

   /** Return an instance to the error queue */
   public static TimeQueue getErrorQueue()
   {
      return instance.errorQueue;
   }

   /** Return an instance to the success queue */
   public static TimeQueue getSuccessQueue()
   {
      return instance.successQueue;
   }

   
   /** Notify all the queues to shutdown */
   public static void shutdown()
   {
      instance.idleQueue.shutdown();
      instance.pingQueue.shutdown();
      instance.errorQueue.shutdown();
      instance.successQueue.shutdown();
   }

}
