//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER

/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */

package org.cleversafe.layer.communication.network.mina.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.GeneralSecurityException;

import javax.net.ServerSocketFactory;

/**
 * Simple Server Socket factory to create sockets with or without SSL enabled. If SSL enabled a
 * "bougus" SSL Context is used (suitable for test purposes)
 * 
 * @author The Apache Directory Project (mina-dev@directory.apache.org)
 * @version $Rev: 448075 $, $Date: 2006-09-20 14:26:53 +0900 (수, 20 9월 2006) $
 */
public class SSLServerSocketFactory extends javax.net.ServerSocketFactory
{
   private static boolean sslEnabled = false;

   private static javax.net.ServerSocketFactory sslFactory = null;

   private static ServerSocketFactory factory = null;

   public SSLServerSocketFactory()
   {
      super();
   }

   public ServerSocket createServerSocket(int port) throws IOException
   {
      return new ServerSocket(port);
   }

   public ServerSocket createServerSocket(int port, int backlog) throws IOException
   {
      return new ServerSocket(port, backlog);
   }

   public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress)
         throws IOException
   {
      return new ServerSocket(port, backlog, ifAddress);
   }

   public static javax.net.ServerSocketFactory getServerSocketFactory() throws IOException
   {
      if (isSslEnabled())
      {
         if (sslFactory == null)
         {
            try
            {
               // TODO: this must take non-null certificate and certificate password arguments
               sslFactory = SSLContextFactory.getInstance(true, null, null).getServerSocketFactory();
            }
            catch (GeneralSecurityException e)
            {
               IOException ioe = new IOException("could not create SSL socket");
               ioe.initCause(e);
               throw ioe;
            }
         }
         return sslFactory;
      }
      else
      {
         if (factory == null)
         {
            factory = new SSLServerSocketFactory();
         }
         return factory;
      }

   }

   public static boolean isSslEnabled()
   {
      return sslEnabled;
   }

   public static void setSslEnabled(boolean newSslEnabled)
   {
      sslEnabled = newSslEnabled;
   }
}
