//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: John Quigley <jquigley@cleversafe.com>
//
// Date: Sep 08, 2007
//---------------------

package org.cleversafe.layer.communication.memory;

import org.cleversafe.exceptions.InitializationException;
import org.cleversafe.layer.communication.Connector;
import org.cleversafe.layer.communication.exceptions.CommunicationConnectionException;
import org.cleversafe.layer.communication.exceptions.CommunicationIOException;
import org.cleversafe.layer.communication.exceptions.CommunicationInterruptedException;
import org.cleversafe.layer.communication.exceptions.CommunicationResponseException;
import org.cleversafe.layer.communication.exceptions.CommunicationTransmissionException;
import org.cleversafe.layer.communication.exceptions.NotConnectedException;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.cleversafe.server.ClientSession;
import org.cleversafe.server.RequestHandler;
import org.cleversafe.server.ServerApplication;

/**
 * This class provides a loopback-like Connector, which embeds a generic ServerApplication
 * implementation for in-memory servicing of requests.
 * 
 * @author John Quigley <jquigley@cleversafe.com>
 * @version $Id$
 */
public abstract class MemoryConnector extends ServerApplication implements Connector
{
   protected ClientSession _session = null;
   protected boolean _isConnected = false;
   protected boolean _isInitialized = false;
   protected String _endpointAddress = "localhost:<memory>";


   // //////////////////////////////////////////////////////////////////////////
   // abstract methods.

   /**
    * @see Connector#exchange(Request)
    */
   public abstract Response exchange(Request request) throws CommunicationIOException,
         NotConnectedException, CommunicationInterruptedException, CommunicationResponseException,
         CommunicationTransmissionException;

   /**
    * @see Connector#exchange(Request, int)
    */
   public abstract Response exchange(Request request, int timeout) throws CommunicationIOException,
         NotConnectedException, CommunicationInterruptedException, CommunicationResponseException,
         CommunicationTransmissionException;

   /**
    * 
    */
   public abstract Response service(Request request, ClientSession session);

   public abstract void addHandler(RequestHandler handler);

   public abstract void removeHandler(RequestHandler handler);

   // ///////////////////////////////////////////////////////////////////////////
   // default Connector implementation
   public boolean ensureConnected() throws CommunicationIOException,
         CommunicationConnectionException
   {
      if (isConnected())
      {
         return false;
      }
      else
      {
         connect();
         return true;
      }
   }

   public void connect() throws CommunicationIOException, CommunicationConnectionException
   {
      this._isConnected = true;
   }

   public void disconnect() throws CommunicationIOException, CommunicationInterruptedException
   {
      this._isConnected = false;
   }

   public String getLocalAddress()
   {
      return this._endpointAddress;
   }

   public String getRemoteAddress()
   {
      return this._endpointAddress;
   }

   public void initialize()
   {
      if (this._isInitialized)
      {
         throw new InitializationException("connection has already been initialized");
      }

      this._session = new ClientSession();
      this._isInitialized = true;
   }

   public boolean isConnected()
   {
      return this._isConnected;

   }

   public String getIdentification()
   {
      return "In-Memory connector : " + getRemoteAddress();
   }

   public void sendPing() throws CommunicationInterruptedException, CommunicationResponseException,
         CommunicationTransmissionException, CommunicationIOException, NotConnectedException
   {
      // nothing to do
   }

}
