//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: abaptist
//
// Date: Sep 27, 2007
//---------------------

package org.cleversafe.layer.communication;

import org.cleversafe.layer.communication.exceptions.CommunicationConnectionException;
import org.cleversafe.layer.communication.exceptions.CommunicationIOException;

/**
 * A connector manager is used to add logic to the underlying connection in terms of keep alive,
 * error handling and idle disconnects.
 * 
 * In order to work correctly, the underlying connector needs to notify the manager when the
 * following events happen
 * <ul>
 * <li>A successful exchange is performed
 * <li>An error occurs during an exchange
 * </ul>
 * 
 * @see Connector
 * @author Andrew Baptist <abaptist@cleversafe.com>
 * @version $Id$
 */
public interface ConnectorManager
{
   /**
    * This will attempt to connect to the remote site depending on the connection policy that
    * determines number of retries This calls IPNetworkConnector.connect underneath.
    * 
    * @return
    * @throws CommunicationIOException
    * @throws CommunicationConnectionException
    */
   public boolean ensureConnected() throws CommunicationIOException,
         CommunicationConnectionException;

   /**
    * This is called when a successful response is received
    * 
    * @param response
    */
   public void onSuccess();


   /**
    * This is called when an error occurs on the connection
    */
   /**
    * This is called when an error occurs on the connection
    */
   public void onError();

   /**
    * This is called when the connection is done with initialization. Note this does not throw an
    * exception, if it attempts to connect and succeeds.
    */
   public void onConnectorInit();

   /**
    * This is used to set the connection
    * 
    * @param connector -
    *           the connection this manager is managing
    */
   public void setConnection(Connector connector);

}
