//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: gdhuse
//
// Date: May 8, 2007
//---------------------

package org.cleversafe.ida.cauchy;

import org.cleversafe.ida.InformationDispersalCodec;
import org.cleversafe.ida.InformationDispersalCodecBase;
import org.cleversafe.ida.InformationDispersalDecoder;
import org.cleversafe.ida.InformationDispersalEncoder;
import org.cleversafe.ida.exceptions.IDAInvalidParametersException;

/**
 * Cauchy Reed-Solomon IDA implementation
 * 
 * @deprecated This IDA is not being adequately maintained or tested, consider removing
 */
public class CauchyInformationDispersalCodec extends InformationDispersalCodecBase
      implements
         InformationDispersalCodec
{
   public static final String NAME = "cauchy";
   
   /**
    * This constructor is used to construct an object from configuration It
    * should be followed buy initialzie() method invocation
    * 
    */
   public CauchyInformationDispersalCodec()
   {
      super();
   }

   @Override
   protected InformationDispersalDecoder getNewDecoder()
   {
      return new CauchyInformationDispersalDecoder();
   }

   @Override
   protected InformationDispersalEncoder getNewEncoder()
   {
      return new CauchyInformationDispersalEncoder();
   }
   
   /**
    * Construct a new Cauchy Reed-Solomon IDA
    * 
    * @param numSlices
    *           Number of slices to produce
    * @param threshold
    *           Number of recoverable slice losses
    */

   public CauchyInformationDispersalCodec(int numSlices, int threshold) throws
         IDAInvalidParametersException
   {
      super(numSlices, threshold);

      if (this.numSlices < 1) 
      {
         throw new IDAInvalidParametersException("Number of slices must be positive");
      }
      if (this.threshold <= 0)
      {
         throw new IDAInvalidParametersException("Threshold must be greater than zero");
      }
      if (this.threshold > this.numSlices) 
      {
         throw new IDAInvalidParametersException("Threshold must be less than or equal to number of slices");
      }
      
      initialize();
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.ida.InformationDispersalCodec#getName()
    */
   public String getName()
   {
      return NAME;
   }

   /*
    * (non-Javadoc)
    * @see org.cleversafe.ida.InformationDispersalCodec#getBlowup()
    */
   public float getBlowup()
   {
      return this.getNumSlices() / (float)(this.getThreshold());
   }

   public long getDispersedSize(long inputSize)
   {
      int numSegments = 43;
      int fieldSize = 8;
      
      CauchyInformationDispersalEncoder encoder;
      encoder = new CauchyInformationDispersalEncoder(this.numSlices, this.threshold);
      
      int sliceLength = numSegments * fieldSize;
      
      int messageLength = sliceLength * encoder.getThreshold();
      
      int encodedLength = (sliceLength + 1) * encoder.getNumSlices();
      
      return ((inputSize / messageLength) + 1) * encodedLength;
   }

}
