//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: Vance Thornton
//
//---------------------

package org.cleversafe.ida;

import java.util.List;

import org.cleversafe.ida.exceptions.IDAEncodeException;
import org.cleversafe.ida.exceptions.IDAException;
import org.cleversafe.ida.exceptions.IDAInvalidParametersException;
import org.cleversafe.ida.exceptions.IDANotInitializedException;



public interface InformationDispersalEncoder
{
   /**
    * Prepares the encoder to begin processing data.
    */
   //public void initialize() throws IDAInvalidParametersException;

   /**
    * Continues a multiple-part encoding operation.
    * 
    * @param buffer
    *           The data to encoded
    * 
    * @return A list of encoded data buffers if a sufficient amount of data has
    *         been made available for encoding, otherwise null
    * @throws IDAException
    */
   //public List<byte[]> update(byte buffer[])
   //      throws IDAEncodeException, IDANotInitializedException;

   /**
    * Performs a complete encoding operation or finishes a multiple-part
    * encoding operation.
    * 
    * @param buffer
    *           The data to encoded
    * 
    * @return A list of encoded data buffers
    */
   public List<byte[]> finish(byte buffer[])
         throws IDAEncodeException, IDANotInitializedException;

   /**
    * Returns the number of slices
    * 
    * @return The number of slices
    */
   public int getNumSlices();

   /**
    * Returns the number of slices which are required to restore data.
    * 
    * @return The number of slices which are required to restore data
    */
   public int getThreshold();
   
   /**
    * Returns the chunk size
    * 
    * @return The chunk size
    */
   public int getChunkSize();
   
   public void setNumSlices(int numSlices);
   public void setThreshold(int threshold);
   public void setChunkSize(int chunkSize);
}
