//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: jquigley
//
// Date: Aug 20, 2007
//---------------------

package org.cleversafe.exceptions;
import org.apache.log4j.Logger;

public class RuntimeException extends java.lang.RuntimeException
{
   private static final long serialVersionUID = 9098145674114181017L;
   
   private static Logger _logger = Logger.getLogger(RuntimeException.class);
   
   public RuntimeException()
   {
      super();
      _logger.error("Exception", this);
   }

   public RuntimeException(String reason, Throwable cause)
   {
      super(reason == null ? "" : reason, cause);
      _logger.error("Exception: " + reason, this);
   }

   public RuntimeException(String reason)
   {
      super(reason);
      _logger.error("Exception: " + reason, this);
   }

   public RuntimeException(Throwable cause)
   {
      super(cause);
      _logger.error("Exception", this);
   }

   public String getMessage()
   {
      return super.getMessage();
   }

   public String toString()
   {
      StringBuffer fullMessage = new StringBuffer();

      if (getMessage() != null)
      {
         fullMessage.append(getMessage());
      }
      else
      {
         fullMessage.append("(No message provided)");
      }

      if (getCause() != null)
      {
         if (getCause().getMessage() != null)
         {
            fullMessage.append(", Caused by: ").append(getCause().getMessage());
         }
      }
      return fullMessage.toString();
   }
}
