//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: ivolvovski
//
// Date: Jun 18, 2007
//---------------------

package org.cleversafe.config.evaluator;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;
import org.cleversafe.config.exceptions.ObjectInstantiationException;

// Literal Factory
public class LiteralEvaluatorFactory
{
   private static Logger _logger = Logger.getLogger(LiteralEvaluatorFactory.class);

   private static Map<String, Constructor<?>> supportedTypes =
         new HashMap<String, Constructor<?>>();;
   static
   {
      try
      {
         supportedTypes.put("string", StringLiteral.class.getConstructor(String.class));
         supportedTypes.put("int", IntegerLiteral.class.getConstructor(String.class));
         supportedTypes.put("long", LongLiteral.class.getConstructor(String.class));
         supportedTypes.put("short", ShortLiteral.class.getConstructor(String.class));
         supportedTypes.put("byte", ByteLiteral.class.getConstructor(String.class));
         supportedTypes.put("boolean", BooleanLiteral.class.getConstructor(String.class));
         supportedTypes.put("float", FloatLiteral.class.getConstructor(String.class));
         supportedTypes.put("double", DoubleLiteral.class.getConstructor(String.class));
         // supportedTypes.put("char", CharacterLiteral.class.getConstructor(String.class));
      }
      catch (Exception ex)
      {
         _logger.error("Can't instantiate supported types for literal factory", ex);
      }
   }

   private LiteralEvaluatorFactory()
   {
   }

   /**
    * Checks for a supported type
    * 
    * @param type
    * @return
    */
   static public boolean hasEvaluator(String type)
   {
      return supportedTypes.get(type) != null;
   }

   /**
    * Returns a literal of the appropriate type
    * 
    * @param type
    *           literal type
    * @param value
    *           literal value
    * @return
    */
   static public LiteralEvaluator getEvaluator(String type, String value)
         throws ObjectInstantiationException
   {
      Constructor<?> literalConstructor = supportedTypes.get(type);
      if (literalConstructor == null)
      {
         throw new IllegalArgumentException("Literal of type " + type + " is not supported");
      }

      LiteralEvaluator evaluator = null;

      try
      {
         evaluator = (LiteralEvaluator) literalConstructor.newInstance(value);
      }
      catch (Exception e)
      {
         throw new ObjectInstantiationException("Could not create literal evaluator!", e);
      }
      return evaluator;
   }
}
