//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: ivolvovski
//
// Date: Jun 18, 2007
//---------------------

package org.cleversafe.config.evaluator;

import java.lang.reflect.Method;
import java.util.List;

import org.cleversafe.config.exceptions.MethodInvocationException;
import org.cleversafe.config.exceptions.ObjectInitializationException;
import org.cleversafe.util.TypeUtils;

// TODO: Describe class or interface
abstract class JavaMethodEvaluatorImpl
{
   private String methodName;
   private List<Evaluatable> parameters;

   /**
    * @param method
    * @param parameters
    */
   public JavaMethodEvaluatorImpl(String method, List<Evaluatable> parameters)
   {
      super();
      assert method != null && method != "";

      this.methodName = method;
      this.parameters = parameters;
   }

   Object evaluateStatic(Class<?> clazz) throws MethodInvocationException,
         ObjectInitializationException
   {
      return evaluateImpl(clazz);
   }

   Object evaluateInstance(Object instance) throws MethodInvocationException,
         ObjectInitializationException
   {
      return evaluateImpl(instance);
   }

   private Object evaluateImpl(Object instance) throws MethodInvocationException,
         ObjectInitializationException
   {
      // Create parameter type array
      Class<?>[] paramTypes = new Class[this.parameters.size()];
      Object[] paramValues = new Object[this.parameters.size()];
      int i = 0;

      for (Evaluatable param : this.parameters)
      {
         paramValues[i] = param.evaluate();
         paramTypes[i] = paramValues[i].getClass();
         i++;
      }

      String className = "";
      Method m = null;
      try
      {
         if (instance instanceof Class)
         { // Static method
            className = ((Class<?>) instance).getName();
            m = TypeUtils.getMatchingMethod((Class<?>) instance, this.methodName, paramTypes, true);
            if (m != null)
            {
               return m.invoke(null, paramValues);
            }
         }
         else
         {
            className = instance.getClass().getName();
            m =
                  TypeUtils.getMatchingMethod(instance.getClass(), this.methodName, paramTypes,
                        false);
            if (m != null)
            {
               return m.invoke(instance, paramValues);
            }
         }
         assert m == null;
         throw new MethodInvocationException("Can't find method match:" + this.methodName + "("
               + TypeUtils.listOfClassesToStr(paramTypes) + ")");

      }
      catch (Exception e)
      {
         throw new MethodInvocationException("Error invoking " + methodName + "("
               + TypeUtils.listOfClassesToStr(paramTypes) + ") for object of type " + className, e);
      }
   }
}
