//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: ivolvovski
//
// Date: May 11, 2007
//---------------------

package org.cleversafe.config;

import java.util.ArrayList;
import java.util.List;

import org.cleversafe.config.exceptions.ConfigurationItemNotDefinedException;

/**
 * A System Properties class that implements PropertyInterface
 * 
 * @author Ilya Volvovski, Manish Motwani
 */
public class SystemProperties implements PropertyInterface
{
   /*
    * (non-Javadoc)
    * 
    * @see com.clevesafe.config.PropertyInterface#getvalue(java.lang.String[])
    */
   public String getValue(final String[] fullName) throws ConfigurationItemNotDefinedException
   {
      final StringBuffer buf = new StringBuffer();
      for (final String part : fullName)
      {
         buf.append(part).append(".");
      }
      if (buf.length() > 0)
      {
         buf.setLength(buf.length() - 1);
         final String propertyKey = buf.toString();
         final String value = System.getProperty(propertyKey);
         if (value == null)
         {
            throw new ConfigurationItemNotDefinedException("System property not defined: "
                  + propertyKey);
         }
         else
         {
            return value;
         }
      }
      else
      {
         throw new ConfigurationItemNotDefinedException("System property not defined: "
               + fullName.toString());
      }
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.config.PropertyInterface#getValuesList(java.lang.String[])
    */
   public List<String> getValuesList(final String[] qualifiedName)
         throws ConfigurationItemNotDefinedException
   {
      final String value = getValue(qualifiedName);
      final List<String> list = new ArrayList<String>();
      list.add(value);
      return list;
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.config.PropertyInterface#isSet(java.lang.String[])
    */
   public boolean isSet(final String[] qualifiedName)
   {
      try
      {
         getValue(qualifiedName);
         return true;
      }
      catch (final ConfigurationItemNotDefinedException e)
      {
         return false;
      }
   }
}
