//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: ivolvovski
//
// Date: May 11, 2007
//---------------------

package org.cleversafe.config;

import java.util.List;

import org.cleversafe.config.exceptions.ConfigurationException;

/**
 * A generic property interface that is not type aware and returns only string values for a given
 * qualified property name.
 * 
 * @author Ilya Volvovski, Manish Motwani
 */
public interface PropertyInterface
{
   /**
    * Returns the value for the property specified by the input qualified name. If no such property
    * exists, an exception is thrown.
    * 
    * @param qualifiedName
    *           The qualified name string array that represents the property.
    * @return The value for the input property.
    * @throws ConfigurationException
    */
   public String getValue(final String[] qualifiedName) throws ConfigurationException;

   /**
    * Returns the list of values for the property specified by the input qualified name. If no such
    * property exists, an exception is thrown.
    * 
    * @param qualifiedName
    *           The qualified name string array that represents the property.
    * @return The list of values for the input property.
    * @throws ConfigurationException
    */
   public List<String> getValuesList(final String[] qualifiedName) throws ConfigurationException;

   /**
    * Checks whether the property specified by the input qualified name is set or not.
    * 
    * @param qualifiedName
    *           The qualified name string array that represents the property.
    * @return True if the property is set; false otherwise.
    */
   public boolean isSet(final String[] qualifiedName);
}
